<?php namespace App\Controllers;
 
use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;
use App\Models\ProductModel;
 
class Products extends ResourceController
{
    use ResponseTrait;
    // get all product
    public function index()
    {
        $model = new ProductModel();
        $data = $model->findAll();
        if ($data){
            return $this->respond($data, 200);
        }else{
            return $this->failNotFound('Data tidak ditemukan');
        }
        
    }
 
    // get single product
    public function show($id = null)
    {
        $model = new ProductModel();
        $data = $model->getWhere(['product_id' => $id])->getResult();
        if($data){
            //return $this->respond($data[0]);
            return $this->respond($data);
        }else{
            return $this->failNotFound('No Data Found with id '.$id);
        }
    }
 
    // create a product
    public function create_lama()
    {
        $model = new ProductModel();
        $data = [
            'product_name' => $this->request->getPost('product_name'),
            'product_price' => $this->request->getPost('product_price')
        ];
        $data = json_decode(file_get_contents("php://input"));
        //$data = $this->request->getPost();
        $model->insert($data);
        $response = [
            'status'   => 201,
            'error'    => null,
            'messages' => [
                'success' => 'Data Saved'
            ]
        ];
         
        return $this->respondCreated($data, 201);
    }

    // create a product
    public function create()
    {
        $json=$this->request->getJSON();
       
        $data = [
            'product_name' => $json->product_name,
            'product_price' => $json->product_price
        ];

        $model = new ProductModel();
        $product=$model->insert($data);
if (!$product) return $this->fail('Gagal buat data',400);
return $this->respondCreated($product,201);

        //$data = json_decode(file_get_contents("php://input"));
        //$data = $this->request->getPost();
        //$model->insert($data);
        //$response = [
        //    'status'   => 201,
        //    'error'    => null,
        //    'messages' => [
        //        'success' => 'Data Saved'
        //    ]
        //];
         
        //return $this->respondCreated($data, 201);
    }
 
    public function update($id = null)
    {
        $json=$this->request->getJSON();
     
        $data = [
            'product_name' => $json->product_name,
            'product_price' => $json->product_price
        ];
        $model = new ProductModel();
        $cekId=$model->find(['id'=>$id]);
        if (!$cekId) return $this->fail('Data Tidak ditemukan',404);
        $product=$model->update($id,$data);
if (!$product) return $this->fail('Gagal update',400);
return $this->respond($product);


    }
 
    // update product
    public function update_lama($id = null)
    {
        $model = new ProductModel();
        $json = $this->request->getJSON();
        if($json){
            $data = [
                'product_name' => $json->product_name,
                'product_price' => $json->product_price
            ];
        }else{
            $input = $this->request->getRawInput();
            $data = [
                'product_name' => $input['product_name'],
                'product_price' => $input['product_price']
            ];
        }
        // Insert to Database
        $model->update($id, $data);
        $response = [
            'status'   => 200,
            'error'    => null,
            'messages' => [
                'success' => 'Data Updated'
            ]
        ];
        return $this->respond($response);


    }
 
    // delete product
    public function delete($id = null)
    {
        $model = new ProductModel();
        $data = $model->find($id);
        if($data){
            $model->delete($id);
            $response = [
                'status'   => 200,
                'error'    => null,
                'messages' => [
                'success' => 'Data Deleted'
                ]
            ];
             
            return $this->respondDeleted($response);
        }else{
            return $this->failNotFound('No Data Found with id '.$id);
        }
         
    }

    public function delete_lama($id = null)
    {
        $model = new ProductModel();
        $data = $model->find($id);
        if($data){
            $model->delete($id);
            $response = [
                'status'   => 200,
                'error'    => null,
                'messages' => [
                    'success' => 'Data Deleted'
                ]
            ];
             
            return $this->respondDeleted($response);
        }else{
            return $this->failNotFound('No Data Found with id '.$id);
        }
         
    }
 
}